/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.sfp.surveillance;

import com.ibm.hsc.auiml.databeans.sfp.ConnectionMonitorListener;
import com.ibm.hsc.auiml.databeans.sfp.ConnectionMonitorManager;
import com.ibm.hsc.auiml.databeans.sfp.SFPException;
import com.ibm.hsc.auiml.databeans.sfp.SFPSettingsData;
import com.ibm.hsc.auiml.databeans.sfp.data.CECStateInformation;
import com.ibm.hsc.auiml.databeans.sfp.data.StructuredData;
import com.ibm.hsc.ccfw.pa.event.SurveillanceNotificationDataEvent;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.AusMicrocodeLog;
import com.ibm.hsc.common.util.CIMUtils;
import com.ibm.hsc.common.util.PIHscUtil;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.sfp.surveillance.SurveillanceEvent;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventList;
import com.ibm.hsc.sfp.surveillance.SurveillanceEventType;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionState;
import com.ibm.hsc.sfp.surveillance.SurveillancePartitionStateList;
import com.ibm.hsc.sfp.surveillance.SurveillanceTerminateThread;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.system.ConsoleSystem;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.bridge.NativeBridgeListener;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.pa.system.PASystem;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;
import org.snia.wbem.cim.CIMException;

public class Surveillance
implements NativeBridgeListener,
ConnectionMonitorListener {
    public static final String CEC_MTM_MS_SEPARATOR = "_";
    static final ClassLogInfo SURVEILLANCE_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurveilla");
    static final ClassLogInfo SURVEILLANCE_TIMER_THREAD_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurvTimeT");
    static final ClassLogInfo SURVEILLANCE_EVENT_LIST_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurvEvtLS");
    static final ClassLogInfo SURVEILLANCE_PARTITION_STATE_LIST_LOG_INFO = new ClassLogInfo(-88, 119, "SFPSurvPartL");
    static final short ERRID_PROCESS_SE_ERR = 0;
    static final short ERRID_GETTING_ENABLEMENT_FROM_CIM = 1;
    static final short ERRID_GETTING_CEC_MODE_FROM_CIM = 2;
    static final short ERRID_CALLING_SA = 3;
    static final short ERRID_GET_HMC_MTM = 4;
    static final short ERRID_GET_HMC_MS = 5;
    static final short ERRID_SUBSCRIBING_TO_CIM = 6;
    static final short ERRID_UNSUBSCRIBING_FROM_CIM = 7;
    static final short ERRID_TIMER_THREAD_ERR = 8;
    static final boolean USE_FAKE_CIM_DATA = false;
    static final long REQUIRE_CONNECT_TIMER_IN_MS = 1800000L;
    private static final String TRACE_MASKD = "JSURVEID";
    private static final String TRACE_MASKF = "JSURVEIF";
    private static final String TRACE_MASKT = "JSURVEIT";
    private static Surveillance surveillanceObject = null;
    private static Object surveillanceObjectSynchronizer = new Object();
    private static final Locale ENGLISH_US = new Locale(Locale.ENGLISH.getLanguage(), Locale.US.getCountry());
    private SurveillanceEventList eventList = null;
    private SurveillancePartitionStateList partitionStates = null;
    private long connectTimer = 120000L;
    private long outageTimer = 900000L;
    private long newSETimer = 1200000L;
    private boolean localConnectionUp = false;
    private NativeBridge bridge = null;
    private Object surveillanceObjectTerminator = new Object();
    private boolean terminated = false;

    public Surveillance() {
        this(null);
    }

    public Surveillance(NativeBridge nativeBridge) {
        if (nativeBridge != null) {
            nativeBridge.addNativeBridgeListener((NativeBridgeListener)this);
            this.bridge = nativeBridge;
        }
        PIHscUtil.initHscUtil(5);
    }

    public static void main(String[] stringArray) {
        Surveillance surveillance = new Surveillance();
        try {
            surveillance.callLocalDisconnected("001", "7923-1U", "23WW193");
            surveillance.callLocalDisconnected("002", "6792-31U", "23WW193");
            surveillance.callLocalDisconnected("003", "792-31U", "23WW193");
        }
        catch (SFPException sFPException) {
            sFPException.printStackTrace();
        }
    }

    public void init() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> init()");
        }
        this.initMS();
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- init(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initMS() {
        SFPSettingsData sFPSettingsData = null;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> initMS()");
        }
        Object object = surveillanceObjectSynchronizer;
        synchronized (object) {
            block9: {
                if (surveillanceObject != null) {
                    surveillanceObject.terminate();
                }
                this.partitionStates = new SurveillancePartitionStateList(this);
                this.eventList = new SurveillanceEventList(this, this.partitionStates);
                this.partitionStates.subscribeForCIMEvents(this.eventList);
                this.partitionStates.updateCIMInfo(this.eventList);
                ConnectionMonitorManager.getConnectionMonitorManager().addConnectionMonitorListener(this);
                try {
                    sFPSettingsData = new SFPSettingsData().getConnectionData();
                }
                catch (Exception exception) {
                    if (Trace.LEVEL < 2) break block9;
                    Trace.trace(TRACE_MASKF, "In initMS(...), we got the following exception while getting the timers: " + exception.toString());
                }
            }
            if (sFPSettingsData != null) {
                this.setTimers(sFPSettingsData.settings.getConnectedTimer(), sFPSettingsData.settings.getDisconnectedTimer(), sFPSettingsData.settings.getIntervalTimer());
            }
            surveillanceObject = this;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- initMS(...)");
        }
    }

    public void connected(String string, String string2, String string3, String string4) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> connected(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ")");
        }
        this.addConnect(string, string2, string3, string4, null);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- connected(...)");
        }
    }

    public void connected(String string, String string2, String string3, String string4, String string5) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> connected(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ")");
        }
        if (string5 != null) {
            string5 = string5.trim().length() == 0 ? null : string5.trim();
        }
        this.addConnect(string, string2, string3, string4, string5);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- connected(...)");
        }
    }

    public void disconnected(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> disconnected(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ", " + string6 + ", " + string7 + ")");
        }
        if (string6 != null && string6.indexOf(45) == -1 && string6.length() > 4) {
            string6 = string6.substring(0, 4) + "-" + string6.substring(4);
        }
        this.addDisconnect(string, string2, string3, string4, string5, string6, string7, null);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- disconnected(...)");
        }
    }

    public void disconnected(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> disconnected(" + string + ", " + string2 + ", " + string3 + ", " + string4 + ", " + string5 + ", " + string6 + ", " + string7 + ", " + string8 + ")");
        }
        if (string6 != null && string6.indexOf(45) == -1 && string6.length() > 4) {
            string6 = string6.substring(0, 4) + "-" + string6.substring(4);
        }
        if (string8 != null) {
            string8 = string8.trim().length() == 0 ? null : string8.trim();
        }
        this.addDisconnect(string, string2, string3, string4, string5, string6, string7, string8);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- disconnected(...)");
        }
    }

    public synchronized void localConnected() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> localConnected()");
        }
        this.localConnectionUp = true;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- localConnected()");
        }
    }

    public synchronized void localDisconnected(String string, String string2, String string3) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> localDisconnected(" + string + ", " + string2 + ", " + string3 + ")");
        }
        if (this.localConnectionUp) {
            if (string2 != null && string2.indexOf(45) == -1 && string2.length() > 4) {
                string2 = string2.substring(0, 4) + "-" + string2.substring(4);
            }
            try {
                this.callLocalDisconnected(string, string2, string3);
            }
            catch (SFPException sFPException) {
                new AusMicrocodeLog(SURVEILLANCE_LOG_INFO, 3, sFPException).writeEntry(null);
            }
            this.localConnectionUp = false;
        } else if (Trace.LEVEL >= 3) {
            Trace.trace(TRACE_MASKD, "Ignoring duplicate localDisconnected(...) call");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- localDisconnected(...)");
        }
    }

    private void setTimers(int n, int n2, int n3) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> setTimers(" + n + ", " + n2 + ", " + n3 + ")");
        }
        this.setConnectTimer(n);
        this.setOutageTimer(n2);
        this.setNewSETimer(n3);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- setTimers(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> terminate()");
        }
        Object object = this.surveillanceObjectTerminator;
        synchronized (object) {
            if (!this.terminated) {
                new Thread((Runnable)new SurveillanceTerminateThread(this, this.bridge), "SurveillanceTerminateThread").start();
                this.terminated = true;
                this.bridge = null;
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- terminate(...)");
        }
    }

    private void setConnectTimer(int n) {
        if (this.connectTimer != (long)(n * 60000)) {
            this.connectTimer = n * 60000;
            this.eventList.change(SurveillanceEventType.CONNECT, this.connectTimer);
            this.eventList.change(SurveillanceEventType.NOT_YET_CONNECTED, 1800000L + this.connectTimer);
        }
    }

    long getConnectTimerInMS() {
        return this.connectTimer;
    }

    private void setOutageTimer(int n) {
        if (this.outageTimer != (long)(n * 60000)) {
            this.outageTimer = n * 60000;
            this.eventList.change(SurveillanceEventType.DISCONNECT, this.outageTimer);
        }
    }

    private void setNewSETimer(int n) {
        this.newSETimer = n * 60000;
    }

    private void addConnect(String string, String string2, String string3, String string4, String string5) throws IllegalArgumentException {
        String string6;
        Date date;
        block5: {
            date = null;
            string6 = null;
            SurveillancePartitionState surveillancePartitionState = null;
            if (string5 != null && string5.length() == 0) {
                throw new IllegalArgumentException();
            }
            date = new Date();
            try {
                surveillancePartitionState = this.partitionStates.get(string3, string4, string);
                if (surveillancePartitionState != null) {
                    string6 = surveillancePartitionState.getUserName();
                }
            }
            catch (CIMException cIMException) {
                if (Trace.LEVEL < 2) break block5;
                Trace.trace(TRACE_MASKF, "In addConnect(...), we got the following exception while getting the user name: " + cIMException.toString());
            }
        }
        if (string6 == null) {
            string6 = "";
        }
        this.eventList.add(new SurveillanceEvent(string, string6, string2, date, SurveillanceEventType.CONNECT, string3, string4, null, "", "", string5), this.connectTimer);
    }

    private void addDisconnect(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IllegalArgumentException {
        String string9;
        Date date;
        block5: {
            date = null;
            string9 = null;
            SurveillancePartitionState surveillancePartitionState = null;
            if (string8 != null && string8.length() == 0) {
                throw new IllegalArgumentException();
            }
            date = new Date();
            try {
                surveillancePartitionState = this.partitionStates.get(string3, string4, string);
                if (surveillancePartitionState != null) {
                    string9 = surveillancePartitionState.getUserName();
                }
            }
            catch (CIMException cIMException) {
                if (Trace.LEVEL < 2) break block5;
                Trace.trace(TRACE_MASKF, "In addDisconnect(...), we got the following exception while getting the user name: " + cIMException.toString());
            }
        }
        if (string9 == null) {
            string9 = "";
        }
        this.eventList.add(new SurveillanceEvent(string, string9, string2, date, SurveillanceEventType.DISCONNECT, string3, string4, string5, string6, string7, string8), this.outageTimer);
    }

    boolean doSurveillancePerConfig(String string, String string2, String string3) {
        boolean bl = false;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> doSurveillance(" + string + ", " + string2 + ", " + string3 + ")");
        }
        if (this.doSurveillanceForCEC(string2, string3)) {
            bl = this.doSurveillancePerProfile(string, string2, string3);
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- doSurveillance(...) returning " + bl);
        }
        return bl;
    }

    private boolean doSurveillancePerProfile(String string, String string2, String string3) {
        boolean bl = false;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> doSurveillancePerProfile(" + string + ", " + string2 + ", " + string3 + ")");
        }
        bl = CIMUtils.isSurveillanceEnabled(string, string2, string3);
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- doSurveillancePerCIM(...) returning " + bl);
        }
        return bl;
    }

    private boolean doSurveillanceForCEC(String string, String string2) {
        String string3 = null;
        boolean bl = true;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> doSurveillanceForCEC(" + string + ", " + string2 + ")");
        }
        string3 = string + CEC_MTM_MS_SEPARATOR + string2;
        if (this.isCECDisabled(string, string2)) {
            bl = false;
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- doSurveillanceForCEC(...) returning " + bl);
        }
        return bl;
    }

    long getNewSETimer() {
        return this.newSETimer;
    }

    private void callLocalDisconnected(String string, String string2, String string3) throws SFPException {
        SurveillanceNotificationDataEvent surveillanceNotificationDataEvent = null;
        ConsoleSystem consoleSystem = null;
        ConsoleAnalysisDomain consoleAnalysisDomain = null;
        DomainManager domainManager = null;
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->callLocalDisconnected(" + string + ", " + string2 + ", " + string3 + ")");
        }
        if ((domainManager = DomainManager.getDomainManager()) != null) {
            consoleAnalysisDomain = (ConsoleAnalysisDomain)domainManager.get(ConsoleAnalysisDomain.CAD_DOMAINID);
            if (consoleAnalysisDomain == null) {
                throw new SFPException("Cannot get HMC console domain.");
            }
        } else {
            throw new SFPException("Cannot get Problem Analysis Domain Manager.");
        }
        consoleSystem = consoleAnalysisDomain.getConsoleSystem();
        surveillanceNotificationDataEvent = new SurveillanceNotificationDataEvent(this);
        surveillanceNotificationDataEvent.setFailureReason(4);
        surveillanceNotificationDataEvent.setEndPointA((PASystem)consoleSystem);
        surveillanceNotificationDataEvent.setSRC(string);
        surveillanceNotificationDataEvent.setSvcEventText(Surveillance.getTranslatedErrorText(ENGLISH_US, string, null, true, string3));
        surveillanceNotificationDataEvent.log();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-callLocalDisconnected(...)");
        }
    }

    static String getTimeStamp() {
        Date date = new Date();
        return StructuredData.TS_FORMATTER.format(date);
    }

    public void connectionEstablished(NativeBridge nativeBridge) {
    }

    public void connectionClosed(NativeBridge nativeBridge, IOException iOException) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->connectionClosed(" + nativeBridge + ", " + iOException);
        }
        this.terminate();
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-connectionClosed(...)");
        }
    }

    private boolean isCECDisabled(String string, String string2) {
        String string3;
        CECStateInformation cECStateInformation;
        CECStateInformation[] cECStateInformationArray;
        SFPSettingsData sFPSettingsData;
        boolean bl;
        block5: {
            bl = false;
            sFPSettingsData = null;
            cECStateInformationArray = null;
            cECStateInformation = null;
            string3 = null;
            try {
                sFPSettingsData = new SFPSettingsData().getConnectionData();
            }
            catch (Exception exception) {
                if (Trace.LEVEL < 2) break block5;
                Trace.trace(TRACE_MASKF, "In isCECDisabled(...), we got the following exception while getting enablement state: " + exception.toString());
            }
        }
        if (sFPSettingsData != null) {
            cECStateInformationArray = sFPSettingsData.settings.getCecStateInformation();
            for (int i = 0; i < cECStateInformationArray.length; ++i) {
                cECStateInformation = cECStateInformationArray[i];
                if (!cECStateInformation.machineModelType.equals(string) || !cECStateInformation.machineSerial.equals(string2)) continue;
                string3 = HSCResourceBundleUtil.getMessage(ENGLISH_US, "SFPResourceBundle", "DISABLED_LBL", "Disabled", false);
                return cECStateInformation.surveillanceState.equals(string3);
            }
        }
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<->isCECDisabled(" + string + ", " + string2 + ") returned " + bl);
        }
        return bl;
    }

    public void timersChanged(int n, int n2, int n3) {
        this.setTimers(n, n2, n3);
    }

    public static String getTranslatedErrorText(Locale locale, String string, String string2, boolean bl, String string3) {
        String string4 = "";
        Object[] objectArray = null;
        if (string2 != null) {
            objectArray = new Object[]{string2};
        }
        string4 = bl ? "Communication lost with the ctrmc RMC subsystem on the HMC with a serial number of " + string3 + ". Without this communication, serviceable events cannot be created on the HMC. The communication error code was " + string + "." : HSCResourceBundleUtil.getMessage(locale, "SFPResourceBundleMessages", "0109", "Communications to the SFP component on partition " + string2 + " are unavailable.", objectArray, false);
        return string4;
    }

    void cleanup(NativeBridge nativeBridge) {
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "->cleanup(" + nativeBridge + ")");
        }
        this.eventList.deleteAll();
        this.partitionStates.unsubscribeForCIMEvents();
        if (nativeBridge != null) {
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "removing ourselves as listener for bridge " + nativeBridge);
            }
            nativeBridge.removeNativeBridgeListener((NativeBridgeListener)this);
            if (Trace.LEVEL >= 3) {
                Trace.trace(TRACE_MASKD, "removed ourselves as listener.");
            }
        }
        ConnectionMonitorManager.getConnectionMonitorManager().removeConnectionMonitorListener(this);
        if (Trace.LEVEL >= 1) {
            Trace.trace(TRACE_MASKT, "<-cleanup(...)");
        }
    }
}

